import React from 'react';
import { HashRouter, Routes, Route, Navigate } from 'react-router-dom';
import { Home } from './pages/Home';
import { Learning } from './pages/Learning';
import { Shopping } from './pages/Shopping';
import { Transport } from './pages/Transport';
import { Health } from './pages/Health';
import { Prescription } from './pages/Prescription';
import { PageRoute } from './types';

function App() {
  return (
    <HashRouter>
      <Routes>
        <Route path={PageRoute.HOME} element={<Home />} />
        <Route path={PageRoute.LEARNING} element={<Learning />} />
        <Route path={PageRoute.SHOPPING} element={<Shopping />} />
        <Route path={PageRoute.TRANSPORT} element={<Transport />} />
        <Route path={PageRoute.HEALTH} element={<Health />} />
        <Route path={PageRoute.PRESCRIPTION} element={<Prescription />} />
        <Route path="*" element={<Navigate to={PageRoute.HOME} replace />} />
      </Routes>
    </HashRouter>
  );
}

export default App;
