import React from 'react';
import { Link, useLocation } from 'react-router-dom';
import { Home, ShoppingBag, Heart, Truck, BookOpen } from 'lucide-react';
import { PageRoute } from '../types';

export const Navbar: React.FC = () => {
  const location = useLocation();

  const navItems = [
    { icon: Home, label: '首頁', path: PageRoute.HOME },
    { icon: ShoppingBag, label: '柑仔店', path: PageRoute.SHOPPING },
    { icon: Truck, label: '交通', path: PageRoute.TRANSPORT },
    { icon: Heart, label: '健康', path: PageRoute.HEALTH },
    { icon: BookOpen, label: '學習', path: PageRoute.LEARNING },
  ];

  return (
    <nav className="fixed bottom-0 w-full max-w-md bg-white border-t border-gray-200 flex justify-around items-center p-2 z-40 pb-safe">
      {navItems.map((item) => {
        const isActive = location.pathname === item.path;
        return (
          <Link
            key={item.path}
            to={item.path}
            className={`flex flex-col items-center justify-center w-full py-2 transition-colors ${
              isActive ? 'text-primary' : 'text-gray-400 hover:text-gray-600'
            }`}
          >
            <item.icon size={24} strokeWidth={isActive ? 2.5 : 2} />
            <span className={`text-xs mt-1 ${isActive ? 'font-bold' : ''}`}>
              {item.label}
            </span>
          </Link>
        );
      })}
    </nav>
  );
};
