import React from 'react';
import { Layout } from '../components/Layout';
import { MOCK_HEALTH_DATA } from '../constants';
import { LineChart, Line, XAxis, YAxis, CartesianGrid, Tooltip, ResponsiveContainer, ReferenceLine } from 'recharts';
import { Activity, Thermometer } from 'lucide-react';

export const Health: React.FC = () => {
  return (
    <Layout title="我的健康存摺">
      <div className="space-y-6">
        
        {/* Vital Cards */}
        <div className="grid grid-cols-2 gap-4">
          <div className="bg-white p-4 rounded-xl shadow-sm border border-gray-100 border-l-4 border-l-red-400">
            <div className="flex items-center gap-2 text-gray-500 mb-1">
              <Activity size={18} />
              <span>血壓 (收縮)</span>
            </div>
            <div className="text-3xl font-bold text-gray-800">127 <span className="text-sm font-normal text-gray-400">mmHg</span></div>
          </div>
           <div className="bg-white p-4 rounded-xl shadow-sm border border-gray-100 border-l-4 border-l-blue-400">
            <div className="flex items-center gap-2 text-gray-500 mb-1">
              <Activity size={18} />
              <span>心跳</span>
            </div>
            <div className="text-3xl font-bold text-gray-800">73 <span className="text-sm font-normal text-gray-400">bpm</span></div>
          </div>
        </div>

        {/* Chart Section */}
        <div className="bg-white p-4 rounded-xl shadow-sm border border-gray-100">
          <h3 className="text-lg font-bold mb-4">本週血壓趨勢</h3>
          <div className="h-64 w-full">
            <ResponsiveContainer width="100%" height="100%">
              <LineChart data={MOCK_HEALTH_DATA}>
                <CartesianGrid strokeDasharray="3 3" vertical={false} stroke="#eee" />
                <XAxis dataKey="date" tick={{fontSize: 12}} axisLine={false} tickLine={false} />
                <YAxis domain={[60, 160]} hide />
                <Tooltip 
                  contentStyle={{borderRadius: '8px', border: 'none', boxShadow: '0 4px 6px -1px rgb(0 0 0 / 0.1)'}}
                />
                <ReferenceLine y={120} stroke="green" strokeDasharray="3 3" label={{ position: 'right',  value: '標準', fontSize: 10, fill: 'green' }} />
                <Line type="monotone" dataKey="systolic" stroke="#F87171" strokeWidth={3} dot={{r: 4}} name="收縮壓" />
                <Line type="monotone" dataKey="diastolic" stroke="#60A5FA" strokeWidth={3} dot={{r: 4}} name="舒張壓" />
              </LineChart>
            </ResponsiveContainer>
          </div>
          <div className="flex justify-center gap-4 mt-2 text-sm text-gray-500">
             <div className="flex items-center gap-1"><div className="w-3 h-3 rounded-full bg-red-400"></div>收縮壓</div>
             <div className="flex items-center gap-1"><div className="w-3 h-3 rounded-full bg-blue-400"></div>舒張壓</div>
          </div>
        </div>

        {/* Action Button */}
        <button className="w-full bg-primary text-white py-4 rounded-xl text-xl font-bold shadow-lg hover:bg-teal-700 active:scale-95 transition-all flex items-center justify-center gap-2">
           <Thermometer />
           輸入今日量測數據
        </button>
      </div>
    </Layout>
  );
};
