import React from 'react';
import { Layout } from '../components/Layout';
import { MOCK_COURSES } from '../constants';
import { PlayCircle } from 'lucide-react';

export const Learning: React.FC = () => {
  return (
    <Layout title="社區學習課程">
      <div className="space-y-6">
        <div className="flex gap-2 overflow-x-auto no-scrollbar pb-2">
          {['全部', '健康', '數位', '防詐騙'].map((tag, idx) => (
            <button
              key={idx}
              className={`px-4 py-2 rounded-full text-lg whitespace-nowrap ${
                idx === 0 ? 'bg-primary text-white' : 'bg-white text-gray-600 border border-gray-200'
              }`}
            >
              {tag}
            </button>
          ))}
        </div>

        <div className="space-y-4">
          {MOCK_COURSES.map((course) => (
            <div key={course.id} className="bg-white rounded-xl shadow-sm overflow-hidden border border-gray-100">
              <div className="relative h-48 bg-gray-200">
                <img src={course.thumbnail} alt={course.title} className="w-full h-full object-cover" />
                <div className="absolute inset-0 bg-black/20 flex items-center justify-center">
                  <PlayCircle size={48} className="text-white/90" />
                </div>
                <div className="absolute bottom-2 right-2 bg-black/60 text-white text-xs px-2 py-1 rounded">
                  {course.duration}
                </div>
              </div>
              <div className="p-4">
                <span className="text-xs font-bold text-secondary mb-1 block">
                  {course.category === 'Health' ? '健康講座' : course.category === 'Digital' ? '數位教學' : '防詐騙'}
                </span>
                <h3 className="text-xl font-bold text-gray-800">{course.title}</h3>
                <button className="mt-3 w-full bg-primary/10 text-primary py-2 rounded-lg font-bold hover:bg-primary/20">
                  開始觀看
                </button>
              </div>
            </div>
          ))}
        </div>
      </div>
    </Layout>
  );
};
