import React, { useState } from 'react';
import { Layout } from '../components/Layout';
import { MOCK_PRODUCTS } from '../constants';
import { Plus, Minus, ShoppingCart } from 'lucide-react';

export const Shopping: React.FC = () => {
  const [cartCount, setCartCount] = useState(0);

  const addToCart = () => {
    setCartCount(prev => prev + 1);
  };

  return (
    <Layout title="日常用品選購">
      {/* Search/Filter Mockup */}
      <div className="mb-4 flex gap-2">
        <input 
          type="text" 
          placeholder="搜尋商品..." 
          className="flex-1 border border-gray-300 rounded-lg px-4 py-3 text-lg"
        />
        <button className="bg-primary text-white px-4 rounded-lg">
          <ShoppingCart />
          {cartCount > 0 && <span className="ml-1 font-bold">{cartCount}</span>}
        </button>
      </div>

      {/* Product Grid */}
      <div className="grid grid-cols-2 gap-4">
        {MOCK_PRODUCTS.map((product) => (
          <div key={product.id} className="bg-white rounded-xl overflow-hidden shadow-sm border border-gray-100 flex flex-col">
            <div className="h-32 bg-gray-100 relative">
               <img src={product.image} alt={product.name} className="w-full h-full object-cover" />
               <span className="absolute top-2 left-2 bg-black/60 text-white text-xs px-2 py-1 rounded">
                 {product.category === 'Food' ? '食品' : product.category === 'Health' ? '保健' : '日用'}
               </span>
            </div>
            <div className="p-3 flex-1 flex flex-col">
              <h3 className="text-lg font-bold text-gray-800 line-clamp-1">{product.name}</h3>
              <p className="text-secondary font-bold text-xl mt-1">${product.price}</p>
              
              <button 
                onClick={addToCart}
                className="mt-auto w-full bg-primary text-white py-2 rounded-lg font-bold flex items-center justify-center gap-2 hover:bg-teal-700 active:scale-95 transition-all"
              >
                <Plus size={18} />
                加入清單
              </button>
            </div>
          </div>
        ))}
      </div>

      <div className="mt-8 p-4 bg-orange-50 rounded-xl border border-orange-200 text-center">
        <p className="text-orange-800 font-bold text-lg mb-1">找不到想買的東西？</p>
        <p className="text-orange-700 mb-3">您可以直接用語音告訴志工您需要什麼。</p>
        <button className="bg-secondary text-white px-6 py-2 rounded-full font-bold shadow-md">
          錄音留言
        </button>
      </div>
    </Layout>
  );
};
