import React from 'react';
import { Navbar } from './Navbar';
import { GeminiAssistant } from './GeminiAssistant';

interface LayoutProps {
  children: React.ReactNode;
  title: string;
  showBack?: boolean;
}

export const Layout: React.FC<LayoutProps> = ({ children, title }) => {
  return (
    <div className="min-h-screen bg-gray-100 flex justify-center items-start">
      {/* Mobile Container Limit */}
      <div className="w-full max-w-md bg-background min-h-screen shadow-2xl relative flex flex-col font-sans">
        {/* Header */}
        <header className="bg-primary text-white p-4 sticky top-0 z-30 shadow-md">
          <div className="flex justify-between items-center">
            <h1 className="text-xl font-bold tracking-wide">{title}</h1>
            <div className="w-8 h-8 rounded-full bg-white/20 flex items-center justify-center">
              <span className="text-sm">翁</span>
            </div>
          </div>
        </header>

        {/* Main Content */}
        <main className="flex-1 p-4 pb-24 overflow-y-auto">
          {children}
        </main>

        {/* Floating AI Button */}
        <GeminiAssistant />

        {/* Bottom Navigation */}
        <Navbar />
      </div>
    </div>
  );
};
