import { Product, VideoCourse, HealthData, BusSchedule } from './types';

// Mock Products for "Smart Grocery Store"
export const MOCK_PRODUCTS: Product[] = [
  { id: '1', name: '有機白米 (2kg)', price: 180, category: 'Food', image: 'https://picsum.photos/200/200?random=1' },
  { id: '2', name: '成人奶粉', price: 450, category: 'Health', image: 'https://picsum.photos/200/200?random=2' },
  { id: '3', name: '衛生紙 (12包)', price: 129, category: 'Daily', image: 'https://picsum.photos/200/200?random=3' },
  { id: '4', name: '醬油', price: 85, category: 'Food', image: 'https://picsum.photos/200/200?random=4' },
  { id: '5', name: '洗潔精', price: 60, category: 'Daily', image: 'https://picsum.photos/200/200?random=5' },
  { id: '6', name: '維他命C', price: 300, category: 'Health', image: 'https://picsum.photos/200/200?random=6' },
];

// Mock Videos for "Community Learning"
export const MOCK_COURSES: VideoCourse[] = [
  { id: '1', title: '防詐騙宣導：猜猜我是誰', duration: '10:00', category: 'Fraud', thumbnail: 'https://picsum.photos/300/180?random=10' },
  { id: '2', title: '長者健康操：每日10分鐘', duration: '15:30', category: 'Health', thumbnail: 'https://picsum.photos/300/180?random=11' },
  { id: '3', title: '手機字體變大教學', duration: '05:45', category: 'Digital', thumbnail: 'https://picsum.photos/300/180?random=12' },
  { id: '4', title: '如何使用LINE視訊', duration: '08:20', category: 'Digital', thumbnail: 'https://picsum.photos/300/180?random=13' },
];

// Mock Health Data for "Health Passbook"
export const MOCK_HEALTH_DATA: HealthData[] = [
  { date: '11/01', systolic: 125, diastolic: 80, heartRate: 72 },
  { date: '11/02', systolic: 128, diastolic: 82, heartRate: 75 },
  { date: '11/03', systolic: 122, diastolic: 78, heartRate: 70 },
  { date: '11/04', systolic: 130, diastolic: 85, heartRate: 78 },
  { date: '11/05', systolic: 126, diastolic: 81, heartRate: 74 },
  { date: '11/06', systolic: 124, diastolic: 79, heartRate: 71 },
  { date: '11/07', systolic: 127, diastolic: 83, heartRate: 73 },
];

// Mock Bus Schedule for "Traffic Inquiry"
export const MOCK_BUS_SCHEDULE: BusSchedule[] = [
  { id: '1', route: '501 苗栗客運', time: '08:30', status: 'On Time' },
  { id: '2', route: '社區接駁車', time: '09:00', status: 'Arrived' },
  { id: '3', route: '501 苗栗客運', time: '10:30', status: 'Delayed' },
  { id: '4', route: '社區接駁車', time: '12:00', status: 'On Time' },
];

// System Instruction for Gemini
export const GEMINI_SYSTEM_INSTRUCTION = `
You are "Ah-De" (阿德), a friendly and patient digital assistant for the Mingde Community (明德社區) App. 
Your users are primarily elderly people living in a rural area.
- Always answer in Traditional Chinese (Taiwan).
- Keep answers short, simple, and encouraging.
- Avoid technical jargon.
- If asked about the app features, explain them simply (Shopping, Health, Transport, Learning, Prescription).
- You care about their health and well-being.
- The community is located in Touwu Township, Miaoli County, near Mingde Reservoir.
`;
