import React from 'react';
import { Link } from 'react-router-dom';
import { ShoppingBag, Truck, Heart, BookOpen, Pill, CalendarCheck } from 'lucide-react';
import { Layout } from '../components/Layout';
import { PageRoute } from '../types';

export const Home: React.FC = () => {
  const menuItems = [
    { title: '社區學習', icon: BookOpen, color: 'bg-blue-500', link: PageRoute.LEARNING, desc: '防詐騙、健康講座' },
    { title: '交通查詢', icon: Truck, color: 'bg-green-600', link: PageRoute.TRANSPORT, desc: '接駁車、共乘' },
    { title: '物資選購', icon: ShoppingBag, color: 'bg-orange-500', link: PageRoute.SHOPPING, desc: '日常用品代購' },
    { title: '健康照護', icon: Heart, color: 'bg-rose-500', link: PageRoute.HEALTH, desc: '量測數據、提醒' },
    { title: '慢籤服務', icon: Pill, color: 'bg-purple-500', link: PageRoute.PRESCRIPTION, desc: '領藥提醒、代領' },
    { title: '活動報名', icon: CalendarCheck, color: 'bg-teal-500', link: PageRoute.HOME, desc: '社區共餐、旅遊' },
  ];

  return (
    <Layout title="明德 e(易)達人">
      {/* Welcome Banner */}
      <div className="bg-gradient-to-br from-primary to-teal-700 rounded-2xl p-6 mb-6 text-white shadow-lg relative overflow-hidden">
        <div className="absolute top-0 right-0 -mr-4 -mt-4 w-24 h-24 bg-white/20 rounded-full blur-xl"></div>
        <h2 className="text-2xl font-bold mb-2">早安，翁爺爺！</h2>
        <p className="opacity-90 text-lg">今天天氣不錯，要去社區走走嗎？</p>
        <div className="mt-4 inline-block bg-white/20 px-3 py-1 rounded-full text-sm">
          下次共餐：11/15 (週五)
        </div>
      </div>

      {/* Main Grid Menu */}
      <div className="grid grid-cols-2 gap-4">
        {menuItems.map((item, index) => (
          <Link
            key={index}
            to={item.link}
            className="bg-white p-5 rounded-2xl shadow-sm border border-gray-100 flex flex-col items-center justify-center gap-3 active:scale-95 transition-transform hover:shadow-md"
          >
            <div className={`${item.color} p-4 rounded-full text-white shadow-sm`}>
              <item.icon size={32} />
            </div>
            <div className="text-center">
              <h3 className="text-xl font-bold text-gray-800">{item.title}</h3>
              <p className="text-gray-500 text-sm mt-1">{item.desc}</p>
            </div>
          </Link>
        ))}
      </div>

      {/* Community News Ticker */}
      <div className="mt-6 bg-yellow-50 border border-yellow-200 rounded-xl p-4 flex items-start gap-3">
        <span className="bg-yellow-500 text-white text-xs px-2 py-1 rounded">公告</span>
        <p className="text-gray-700 text-base">
          本週六上午9點於活動中心舉辦「智慧平板工作坊」，歡迎報名參加！
        </p>
      </div>
    </Layout>
  );
};
