import React from 'react';
import { Layout } from '../components/Layout';
import { MOCK_BUS_SCHEDULE } from '../constants';
import { Clock, MapPin, Phone } from 'lucide-react';

export const Transport: React.FC = () => {
  return (
    <Layout title="交通查詢">
      <div className="space-y-6">
        {/* Status Card */}
        <div className="bg-white rounded-xl p-5 shadow-sm border border-gray-100">
          <h2 className="text-lg font-bold mb-4 flex items-center gap-2">
            <Clock className="text-primary" />
            即時班次
          </h2>
          <div className="space-y-4">
            {MOCK_BUS_SCHEDULE.map((bus) => (
              <div key={bus.id} className="flex justify-between items-center border-b border-gray-100 pb-3 last:border-0">
                <div>
                  <div className="font-bold text-xl text-gray-800">{bus.time}</div>
                  <div className="text-gray-500">{bus.route}</div>
                </div>
                <div className={`px-3 py-1 rounded-full text-sm font-bold ${
                  bus.status === 'On Time' ? 'bg-green-100 text-green-700' :
                  bus.status === 'Delayed' ? 'bg-red-100 text-red-700' :
                  'bg-gray-100 text-gray-600'
                }`}>
                  {bus.status === 'On Time' ? '準點' : bus.status === 'Delayed' ? '誤點' : '已抵達'}
                </div>
              </div>
            ))}
          </div>
        </div>

        {/* Action Buttons */}
        <div className="grid grid-cols-2 gap-4">
          <button className="bg-white p-6 rounded-xl shadow-sm border border-gray-100 flex flex-col items-center gap-2 hover:bg-gray-50">
            <div className="bg-blue-100 p-3 rounded-full text-blue-600">
              <MapPin size={32} />
            </div>
            <span className="font-bold text-lg">接駁車位置</span>
          </button>
          
          <button className="bg-white p-6 rounded-xl shadow-sm border border-gray-100 flex flex-col items-center gap-2 hover:bg-gray-50">
             <div className="bg-green-100 p-3 rounded-full text-green-600">
              <Phone size={32} />
            </div>
            <span className="font-bold text-lg">預約共乘</span>
          </button>
        </div>

        {/* Info */}
        <div className="bg-blue-50 p-4 rounded-xl text-blue-800 text-sm">
          <p className="font-bold mb-1">貼心提醒：</p>
          <p>社區接駁車每週一、三、五行駛。如需前往醫院，請提早一天預約。</p>
        </div>
      </div>
    </Layout>
  );
};
